IF EXISTS (SELECT * FROM sys.objects
		  WHERE object_id = OBJECT_ID(N'[dbo].[P_TABELAS_CRIAR_UUID]')
			 AND type IN ( N'P', N'PC') )
    DROP PROCEDURE [dbo].[P_TABELAS_CRIAR_UUID];
GO

GO
--EXEC P_TABELAS_CRIAR_UUID
CREATE PROCEDURE P_TABELAS_CRIAR_UUID 
WITH ENCRYPTION
AS
DECLARE @CD_EMP INT
DECLARE @CD_FILIAL INT
DECLARE @CD_FILIAL_ANT INT
DECLARE @CD_DOCUMENTO INT
DECLARE @CD_DOCUMENTO_AUX1 INT
DECLARE @CD_DOCUMENTO_AUX2 INT
DECLARE @TIPO_DOCUMENTO INT
DECLARE @TIPO_DOCUMENTO_ANT INT
    SET NOCOUNT ON;
	   DECLARE CCriarUUID CURSOR FAST_FORWARD FOR
		  SELECT
			CD_EMP,
			0 AS CD_FILIAL,
			CD_PROD AS CD_DOCUMENTO,
			0 AS CD_DOCUMENTO_AUX1,
			0 AS CD_DOCUMENTO_AUX2,
			0 AS TIPO_DOCUMENTO
		  FROM
			EST_PROD
		  WHERE
			 UUID IS NULL
		  UNION ALL 
		  SELECT
			 CD_EMP,
			 CD_FILIAL,
			 CD_NF,
			 0 AS CD_DOCUMENTO_AUX1,
			 0 AS CD_DOCUMENTO_AUX2,
			 1 as TIPO_DOCUMENTO
		  FROM
			 EST_NF_ENT
		  WHERE
			CD_EMP =1
			AND UUID IS NULL
			AND DT_ENT >=GETDATE()-396
		 UNION ALL
		  SELECT
			 CD_EMP,
			 CD_FILIAL,
			 CD_PED,
			 0 AS CD_DOCUMENTO_AUX1,
			 0 AS CD_DOCUMENTO_AUX2,
			 2 AS TIPO_DOCUMENTO
		  FROM
			 EST_PED_CP
		  WHERE
			CD_EMP =1
			AND UUID IS NULL
			AND DT_EMI >=GETDATE()-396	
		  UNION ALL 
		  SELECT
			 CD_EMP,
			 CD_FILIAL,
			 CD_NF,
			 0 AS CD_DOCUMENTO_AUX1,
			 0 AS CD_DOCUMENTO_AUX2,
			 3 as TIPO_DOCUMENTO
		  FROM
			 EST_NF_SAI
		  WHERE
			CD_EMP =1
			AND UUID IS NULL
			AND DT_EMI_NF >=GETDATE()-396	
		  UNION ALL 
		  SELECT
			 CD_EMP,
			 CD_FILIAL,
			 CD_PED,
			 0 AS CD_DOCUMENTO_AUX1,
			 0 AS CD_DOCUMENTO_AUX2,
			 4 as TIPO_DOCUMENTO
		  FROM
			 EST_PED_VD
		  WHERE
			CD_EMP =1
			AND UUID IS NULL
			AND DT_EMI_PED >=GETDATE()-396							
		  UNION ALL
		  SELECT
			CD_EMP,
			0 AS CD_FILIAL,
			CD_FORN,
			0 AS CD_DOCUMENTO_AUX1,
			0 AS CD_DOCUMENTO_AUX2,
			5 AS TIPO_DOCUMENTO
		  FROM
			PG_FORN
		  WHERE
			 UUID IS NULL
		  UNION ALL
		  SELECT
			CD_EMP,
			CD_FILIAL,
			CD_PG_CRED,
			0 AS CD_DOCUMENTO_AUX1,
			0 AS CD_DOCUMENTO_AUX2,
			6 AS TIPO_DOCUMENTO
		  FROM
			PG_CRED
		  WHERE
			 UUID IS NULL
		  UNION ALL
		  SELECT
			CD_EMP,
			CD_FILIAL,
			CD_PG_CRED,
			CD_DP_LANC AS CD_DOCUMENTO_AUX1,
			0 AS CD_DOCUMENTO_AUX2,
			7 AS TIPO_DOCUMENTO
		  FROM
			PG_DEB
		  WHERE
			 UUID IS NULL
		  UNION ALL
		  SELECT
			CD_EMP,
			0 AS CD_FILIAL,
			CD_CLI AS CD_DOCUMENTO,
			0 AS CD_DOCUMENTO_AUX1,
			0 AS CD_DOCUMENTO_AUX2,
			8 AS TIPO_DOCUMENTO
		  FROM
			RC_CLI
		  WHERE
			 UUID IS NULL
		  UNION ALL
		  SELECT
			0 as CD_EMP,
			0 AS CD_FILIAL,
			CD_CTR AS CD_DOCUMENTO,
			0 AS CD_DOCUMENTO_AUX1,
			0 AS CD_DOCUMENTO_AUX2,
			9 AS TIPO_DOCUMENTO
		  FROM
			EST_NF_ENT_DANFE_PROVISORIO
		  WHERE
			 UUID IS NULL
		  UNION ALL
		  SELECT
			CD_EMP,
			CD_FILIAL,
			0 AS CD_DOCUMENTO,
			0 AS CD_DOCUMENTO_AUX1,
			0 AS CD_DOCUMENTO_AUX2,
			10 AS TIPO_DOCUMENTO
		  FROM
			PRC_FILIAL
		  WHERE
			 UUID IS NULL
		  UNION ALL
		  SELECT
			CD_EMP,
			CD_FILIAL,
			CD_IMP AS CD_DOCUMENTO,
			CD_PROD AS CD_DOCUMENTO_AUX1,
			0 AS CD_DOCUMENTO_AUX2,
			11 AS TIPO_DOCUMENTO
		  FROM
			EST_PROD_IMP
		  WHERE
			 UUID IS NULL
		  UNION ALL
		  SELECT
			CD_EMP,
			0 AS CD_FILIAL,
			CD_RAT_DESP AS CD_DOCUMENTO,
			0 AS CD_DOCUMENTO_AUX1,
			0 AS CD_DOCUMENTO_AUX2,
			12 AS TIPO_DOCUMENTO
		  FROM
			PG_DESP_RAT
		  WHERE
			 UUID IS NULL
		  UNION ALL
		  SELECT
			CD_EMP,
			0 AS CD_FILIAL,
			CD_DESP_REC AS CD_DOCUMENTO,
			0 AS CD_DOCUMENTO_AUX1,
			0 AS CD_DOCUMENTO_AUX2,
			13 AS TIPO_DOCUMENTO
		  FROM
			GLB_DESP_REC
		  WHERE
			 UUID IS NULL
		  UNION ALL
		  SELECT
			CD_EMP,
			CD_FILIAL,
			NR_DP AS CD_DOCUMENTO,
			ANO AS CD_DOCUMENTO_AUX1,
			0 AS CD_DOCUMENTO_AUX2,
			14 AS TIPO_DOCUMENTO
		  FROM
			PG_CRED_DUP_NR_CTR
		  WHERE
			 UUID IS NULL
		  UNION ALL
		  SELECT
			CD_EMP,
			CD_FILIAL,
			NR_DP AS CD_DOCUMENTO,
			ANO AS CD_DOCUMENTO_AUX1,
			0 AS CD_DOCUMENTO_AUX2,
			15 AS TIPO_DOCUMENTO
		  FROM
			RC_DEB_DUP_NR_CTR
		  WHERE
			 UUID IS NULL
		  UNION ALL 
		  SELECT
			CD_EMP,
			CD_FILIAL,
			CD_CTR AS CD_DOCUMENTO,
			0 AS CD_DOCUMENTO_AUX1,
			0 AS CD_DOCUMENTO_AUX2,
			16 AS TIPO_DOCUMENTO
		  FROM
			PDV_CUPOM_NAO_FISCAL
		  WHERE
			 UUID IS NULL
			 AND PDV_CUPOM_NAO_FISCAL.DT_CUPOM >=GETDATE()-396
		  UNION ALL 
		  SELECT
			CD_EMP,
			CD_FILIAL,
			CD_VD AS CD_DOCUMENTO,
			CD_IMP AS CD_DOCUMENTO_AUX1,
			CD_PROD AS CD_DOCUMENTO_AUX2,
			17 AS TIPO_DOCUMENTO
		  FROM
			PDV_VD_DEV_EST_PROD_IMP
		  WHERE
			 UUID IS NULL
			 AND PDV_VD_DEV_EST_PROD_IMP.DT_DEVO >=GETDATE()-396

		  ORDER BY
			CD_FILIAL,
			TIPO_DOCUMENTO
			
	   SET @CD_FILIAL_ANT =0	
	   SET @TIPO_DOCUMENTO_ANT=-1
	   OPEN CCriarUUID;
	   FETCH NEXT FROM CCriarUUID INTO @CD_EMP, @CD_FILIAL, @CD_DOCUMENTO,@CD_DOCUMENTO_AUX1,@CD_DOCUMENTO_AUX2,@TIPO_DOCUMENTO;

	   WHILE @@FETCH_STATUS = 0
		  BEGIN
			 IF @CD_FILIAL<>@CD_FILIAL_ANT 
				 BEGIN
					PRINT 'Analisando filial.: ' + CONVERT(VARCHAR(5), @CD_FILIAL) + ' (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
					SET @CD_FILIAL_ANT=@CD_FILIAL
				 END

			 IF @TIPO_DOCUMENTO=0 --EST_PROD
				 BEGIN
					IF @TIPO_DOCUMENTO<>@TIPO_DOCUMENTO_ANT 
					 BEGIN
						PRINT 'Analisando cadastro produto.: (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
						SET @TIPO_DOCUMENTO_ANT=@TIPO_DOCUMENTO
					 END				
					 UPDATE
						DOC
					 SET
						UUID=NEWID()
					 FROM
						EST_PROD DOC
					 WHERE
						DOC.CD_EMP=@CD_EMP
						AND DOC.CD_PROD = @CD_DOCUMENTO
				 END

			 IF @TIPO_DOCUMENTO=1 --EST_NF_ENT
				 BEGIN
					IF @TIPO_DOCUMENTO<>@TIPO_DOCUMENTO_ANT 
					 BEGIN
						PRINT 'Analisando nota fiscal de entrada.: (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
						SET @TIPO_DOCUMENTO_ANT=@TIPO_DOCUMENTO
					 END				
					 UPDATE
						DOC
					 SET
						UUID=NEWID()
					 FROM
						EST_NF_ENT DOC
					 WHERE
						DOC.CD_EMP=@CD_EMP
						AND DOC.CD_FILIAL=@CD_FILIAL
						AND DOC.CD_NF = @CD_DOCUMENTO
				 END
			 
			 IF @TIPO_DOCUMENTO=3 --EST_NF_SAI
				 BEGIN
					IF @TIPO_DOCUMENTO<>@TIPO_DOCUMENTO_ANT 
					 BEGIN
						PRINT 'Analisando nota fiscal de saida.: (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
						SET @TIPO_DOCUMENTO_ANT=@TIPO_DOCUMENTO
					 END				
					 UPDATE
						DOC
					 SET
						UUID=NEWID()
					 FROM
						EST_NF_SAI DOC
					 WHERE
						DOC.CD_EMP=@CD_EMP
						AND DOC.CD_FILIAL=@CD_FILIAL
						AND DOC.CD_NF = @CD_DOCUMENTO
				 END

			 IF @TIPO_DOCUMENTO=2 --EST_PED_CP
				 BEGIN
					IF @TIPO_DOCUMENTO<>@TIPO_DOCUMENTO_ANT 
					 BEGIN
						PRINT 'Analisando pedido de compras.: (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
						SET @TIPO_DOCUMENTO_ANT=@TIPO_DOCUMENTO
					 END				
					 UPDATE
						DOC
					 SET
						UUID=NEWID()
					 FROM
						EST_PED_CP DOC
					 WHERE
						DOC.CD_EMP=@CD_EMP
						AND DOC.CD_FILIAL=@CD_FILIAL
						AND DOC.CD_PED = @CD_DOCUMENTO
				 END

			 IF @TIPO_DOCUMENTO=4 --EST_PED_VD
				 BEGIN
					IF @TIPO_DOCUMENTO<>@TIPO_DOCUMENTO_ANT 
					 BEGIN
						PRINT 'Analisando pre-fatura.: (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
						SET @TIPO_DOCUMENTO_ANT=@TIPO_DOCUMENTO
					 END				
					 UPDATE
						DOC
					 SET
						UUID=NEWID()
					 FROM
						EST_PED_VD DOC
					 WHERE
						DOC.CD_EMP=@CD_EMP
						AND DOC.CD_FILIAL=@CD_FILIAL
						AND DOC.CD_PED = @CD_DOCUMENTO
				 END
			 
			 IF @TIPO_DOCUMENTO=5 --PG_FORN
				 BEGIN
					IF @TIPO_DOCUMENTO<>@TIPO_DOCUMENTO_ANT 
					 BEGIN
						PRINT 'Analisando fornecedor.: (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
						SET @TIPO_DOCUMENTO_ANT=@TIPO_DOCUMENTO
					 END				
					 UPDATE
						DOC
					 SET
						UUID=NEWID()
					 FROM
						PG_FORN DOC
					 WHERE
						DOC.CD_EMP=@CD_EMP
						AND DOC.CD_FORN = @CD_DOCUMENTO
				 END

			 IF @TIPO_DOCUMENTO=6 --PG_CRED
				 BEGIN
					IF @TIPO_DOCUMENTO<>@TIPO_DOCUMENTO_ANT 
					 BEGIN
						PRINT 'Analisando contas a pagar.: (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
						SET @TIPO_DOCUMENTO_ANT=@TIPO_DOCUMENTO
					 END				
					 UPDATE
						DOC
					 SET
						UUID=NEWID()
					 FROM
						PG_CRED DOC
					 WHERE
						DOC.CD_EMP=@CD_EMP
						AND CD_FILIAL=@CD_FILIAL
						AND DOC.CD_PG_CRED = @CD_DOCUMENTO
				 END

			 IF @TIPO_DOCUMENTO=7 --PG_DEB
				 BEGIN
					IF @TIPO_DOCUMENTO<>@TIPO_DOCUMENTO_ANT 
					 BEGIN
						PRINT 'Analisando contas a pagar baixa.: (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
						SET @TIPO_DOCUMENTO_ANT=@TIPO_DOCUMENTO
					 END				
					 UPDATE
						DOC
					 SET
						UUID=NEWID()
					 FROM
						PG_DEB DOC
					 WHERE
						DOC.CD_EMP=@CD_EMP
						AND CD_FILIAL=@CD_FILIAL
						AND DOC.CD_PG_CRED = @CD_DOCUMENTO
						AND DOC.CD_DP_LANC = @CD_DOCUMENTO_AUX1
				 END

			 IF @TIPO_DOCUMENTO=8 --RC_CLI
				 BEGIN
					IF @TIPO_DOCUMENTO<>@TIPO_DOCUMENTO_ANT 
					 BEGIN
						PRINT 'Analisando clientes.: (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
						SET @TIPO_DOCUMENTO_ANT=@TIPO_DOCUMENTO
					 END				
					 UPDATE
						DOC
					 SET
						UUID=NEWID()
					 FROM
						RC_CLI DOC
					 WHERE
						DOC.CD_EMP=@CD_EMP
						AND DOC.CD_CLI = @CD_DOCUMENTO
				 END
			
			 IF @TIPO_DOCUMENTO=9 --EST_NF_ENT_DANFE_PROVISORIO
				 BEGIN
					IF @TIPO_DOCUMENTO<>@TIPO_DOCUMENTO_ANT 
					 BEGIN
						PRINT 'Analisando danfe importado.: (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
						SET @TIPO_DOCUMENTO_ANT=@TIPO_DOCUMENTO
					 END				
					 UPDATE
						DOC
					 SET
						UUID=NEWID()
					 FROM
						EST_NF_ENT_DANFE_PROVISORIO DOC
					 WHERE
						DOC.CD_CTR = @CD_DOCUMENTO
				 END

			 IF @TIPO_DOCUMENTO=10 --PRC_FILIAL
				 BEGIN
					IF @TIPO_DOCUMENTO<>@TIPO_DOCUMENTO_ANT 
					 BEGIN
						PRINT 'Analisando Filial cadastro.: (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
						SET @TIPO_DOCUMENTO_ANT=@TIPO_DOCUMENTO
					 END				
					 UPDATE
						DOC
					 SET
						UUID=NEWID()
					 FROM
						PRC_FILIAL DOC
					 WHERE
						DOC.CD_EMP  = @CD_EMP
						AND DOC.CD_FILIAL=@CD_FILIAL
				 END

			IF @TIPO_DOCUMENTO=11 --EST_PROD_IMP
				 BEGIN
					IF @TIPO_DOCUMENTO<>@TIPO_DOCUMENTO_ANT 
					 BEGIN
						PRINT 'Analisando ajuste de estoque.: (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
						SET @TIPO_DOCUMENTO_ANT=@TIPO_DOCUMENTO
					 END				
					 UPDATE
						DOC
					 SET
						UUID=NEWID()
					 FROM
						EST_PROD_IMP DOC
					 WHERE
						DOC.CD_EMP  = @CD_EMP
						AND DOC.CD_FILIAL=@CD_FILIAL
						AND DOC.CD_IMP =@CD_DOCUMENTO
						AND DOC.CD_PROD=@CD_DOCUMENTO_AUX1
				 END
			
			IF @TIPO_DOCUMENTO=12 --PG_DESP_RAT
				 BEGIN
					IF @TIPO_DOCUMENTO<>@TIPO_DOCUMENTO_ANT 
					 BEGIN
						PRINT 'Analisando rateio de despesa.: (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
						SET @TIPO_DOCUMENTO_ANT=@TIPO_DOCUMENTO
					 END				
					 UPDATE
						DOC
					 SET
						UUID=NEWID()
					 FROM
						PG_DESP_RAT DOC
					 WHERE
						DOC.CD_EMP  = @CD_EMP
						AND DOC.CD_RAT_DESP =@CD_DOCUMENTO
				 END
			IF @TIPO_DOCUMENTO=13 --GLB_DESP_REC
				 BEGIN
					IF @TIPO_DOCUMENTO<>@TIPO_DOCUMENTO_ANT 
					 BEGIN
						PRINT 'Analisando cadastro receita.: (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
						SET @TIPO_DOCUMENTO_ANT=@TIPO_DOCUMENTO
					 END				
					 UPDATE
						DOC
					 SET
						UUID=NEWID()
					 FROM
						GLB_DESP_REC DOC
					 WHERE
						DOC.CD_EMP  = @CD_EMP
						AND DOC.CD_DESP_REC =@CD_DOCUMENTO
				 END
			 IF @TIPO_DOCUMENTO=14 --PG_CRED_NR_CTR
				 BEGIN
					IF @TIPO_DOCUMENTO<>@TIPO_DOCUMENTO_ANT 
					 BEGIN
						PRINT 'Analisando contas a pagar numero controle.: (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
						SET @TIPO_DOCUMENTO_ANT=@TIPO_DOCUMENTO
					 END				
					 UPDATE
						DOC
					 SET
						UUID=NEWID()
					 FROM
						PG_CRED_DUP_NR_CTR DOC
					 WHERE
						DOC.CD_EMP=@CD_EMP
						AND CD_FILIAL=@CD_FILIAL
						AND DOC.NR_DP = @CD_DOCUMENTO
						AND DOC.ANO = @CD_DOCUMENTO_AUX1
				 END
			 IF @TIPO_DOCUMENTO=15 --RC_DEB_DUP_NR_CTR
				 BEGIN
					IF @TIPO_DOCUMENTO<>@TIPO_DOCUMENTO_ANT 
					 BEGIN
						PRINT 'Analisando contas a receber numero controle.: (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
						SET @TIPO_DOCUMENTO_ANT=@TIPO_DOCUMENTO
					 END				
					 UPDATE
						DOC
					 SET
						UUID=NEWID()
					 FROM
						RC_DEB_DUP_NR_CTR DOC
					 WHERE
						DOC.CD_EMP=@CD_EMP
						AND CD_FILIAL=@CD_FILIAL
						AND DOC.NR_DP = @CD_DOCUMENTO
						AND DOC.ANO = @CD_DOCUMENTO_AUX1
			 END
			 IF @TIPO_DOCUMENTO=16 --PDV_CUPOM_NAO_FISCAL
				 BEGIN
					IF @TIPO_DOCUMENTO<>@TIPO_DOCUMENTO_ANT 
					 BEGIN
						PRINT 'Analisando contas a receber numero controle.: (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
						SET @TIPO_DOCUMENTO_ANT=@TIPO_DOCUMENTO
					 END				
					 UPDATE
						DOC
					 SET
						UUID=NEWID()
					 FROM
						PDV_CUPOM_NAO_FISCAL DOC
					 WHERE
						DOC.CD_EMP=@CD_EMP
						AND CD_FILIAL=@CD_FILIAL
						AND DOC.CD_CTR = @CD_DOCUMENTO
			 END
			 IF @TIPO_DOCUMENTO=17 --PDV_VD_DEV_EST_PROD_IMP
				 BEGIN
					IF @TIPO_DOCUMENTO<>@TIPO_DOCUMENTO_ANT 
					 BEGIN
						PRINT 'Analisando contas a receber numero controle.: (' + CONVERT(VARCHAR(8), GETDATE(), 114) + ')...';
						SET @TIPO_DOCUMENTO_ANT=@TIPO_DOCUMENTO
					 END				
					 UPDATE
						DOC
					 SET
						UUID=NEWID()
					 FROM
						PDV_VD_DEV_EST_PROD_IMP DOC
					 WHERE
						DOC.CD_EMP=@CD_EMP
						AND CD_FILIAL=@CD_FILIAL
						AND DOC.CD_VD = @CD_DOCUMENTO
						AND DOC.CD_IMP = @CD_DOCUMENTO_AUX1
						AND DOC.CD_PROD = @CD_DOCUMENTO_AUX2
				 END
			FETCH NEXT FROM CCriarUUID INTO @CD_EMP, @CD_FILIAL, @CD_DOCUMENTO,@CD_DOCUMENTO_AUX1,@CD_DOCUMENTO_AUX2,@TIPO_DOCUMENTO;
		  END ;

	   CLOSE CCriarUUID ;
	   DEALLOCATE CCriarUUID ;


